/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.GameRendererAccessor;
import org.figuramc.figura.lua.api.ClientAPI;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin
implements GameRendererAccessor {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    PostChain postEffect;
    @Shadow
    private boolean effectActive;
    @Shadow
    private float fov;
    @Shadow
    private int confusionAnimationTick;
    @Shadow
    @Final
    private Camera mainCamera;
    @Unique
    private boolean avatarPostShader = false;
    @Unique
    private boolean hasShaders;

    @Shadow
    protected abstract double getFov(Camera var1, float var2, boolean var3);

    @Shadow
    protected abstract void loadEffect(ResourceLocation var1);

    @Shadow
    public abstract void checkEntityPostEffect(Entity var1);

    @Shadow
    protected abstract void bobHurt(PoseStack var1, float var2);

    @Shadow
    protected abstract void bobView(PoseStack var1, float var2);

    @Shadow
    public abstract Minecraft getMinecraft();

    @WrapOperation(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix4f;rotation(Lorg/joml/Quaternionfc;)Lorg/joml/Matrix4f;")})
    private Matrix4f onCameraRotation(Matrix4f instance, Quaternionfc quat, Operation<Matrix4f> original) {
        FiguraVec3 offset;
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            original.call(new Object[]{instance, quat});
            return instance;
        }
        float z = 0.0f;
        FiguraVec3 rot = avatar.luaRuntime.renderer.cameraRot;
        if (rot != null) {
            z = (float)rot.z;
        }
        if ((offset = avatar.luaRuntime.renderer.cameraOffsetRot) != null) {
            z += (float)offset.z;
        }
        instance.rotate((Quaternionfc)Axis.ZP.rotationDegrees(z));
        FiguraMat4 mat = avatar.luaRuntime.renderer.cameraMat;
        if (mat != null) {
            instance.set((Matrix4fc)mat.toMatrix4f());
        }
        PoseStack stack = new PoseStack();
        stack.last().pose().set((Matrix4fc)instance);
        float tickDelta = this.mainCamera.getPartialTickTime();
        this.bobHurt(stack, tickDelta);
        if (((Boolean)this.minecraft.options.bobView().get()).booleanValue()) {
            this.bobView(stack, tickDelta);
        }
        instance.set((Matrix4fc)stack.last().pose());
        float h = ((Double)this.minecraft.options.screenEffectScale().get()).floatValue();
        float i = Mth.lerp((float)tickDelta, (float)this.minecraft.player.oSpinningEffectIntensity, (float)this.minecraft.player.spinningEffectIntensity) * h * h;
        if (i > 0.0f) {
            int j = this.minecraft.player.hasEffect(MobEffects.CONFUSION) ? 7 : 20;
            float k = 5.0f / (i * i + 5.0f) - i * 0.04f;
            k *= k;
            Vector3f vector3f = new Vector3f(0.0f, Mth.SQRT_OF_TWO / 2.0f, Mth.SQRT_OF_TWO / 2.0f);
            float l = ((float)this.confusionAnimationTick + tickDelta) * (float)j * ((float)Math.PI / 180);
            instance.rotate(l, (Vector3fc)vector3f);
            instance.scale(1.0f / k, 1.0f, 1.0f);
            instance.rotate(-l, (Vector3fc)vector3f);
        }
        instance.rotate(quat);
        return instance;
    }

    @Inject(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;doEntityOutline()V", shift=At.Shift.AFTER)})
    private void render(DeltaTracker deltaTracker, boolean tick, CallbackInfo ci) {
        Entity entity = this.minecraft.getCameraEntity();
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.checkEntityPostEffect(entity);
            }
            return;
        }
        ResourceLocation resource = avatar.luaRuntime.renderer.postShader;
        if (resource == null) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.checkEntityPostEffect(entity);
            }
            return;
        }
        try {
            this.avatarPostShader = true;
            this.effectActive = true;
            if ((this.postEffect == null || !this.postEffect.getName().equals(resource.toString())) && this.getMinecraft().getResourceManager().getResource(resource).isPresent()) {
                this.loadEffect(resource);
            }
        }
        catch (Exception ignored) {
            this.effectActive = false;
            avatar.luaRuntime.renderer.postShader = null;
        }
    }

    @Inject(method={"checkEntityPostEffect(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkEntityPostEffect(Entity entity, CallbackInfo ci) {
        if (this.avatarPostShader) {
            ci.cancel();
        }
    }

    @Inject(method={"tickFov()V"}, at={@At(value="RETURN")})
    private void tickFov(CallbackInfo ci) {
        Float fov;
        Avatar avatar = AvatarManager.getAvatar(this.minecraft.getCameraEntity());
        if (RenderUtils.vanillaModelAndScript(avatar) && (fov = avatar.luaRuntime.renderer.fov) != null) {
            this.fov = fov.floatValue();
        }
    }

    @Inject(method={"pick(F)V"}, at={@At(value="RETURN")})
    private void pick(float tickDelta, CallbackInfo ci) {
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler("extendedPick");
        FiguraMod.extendedPickEntity = EntityUtils.getViewedEntity(32.0f);
        FiguraMod.popProfiler(2);
    }

    @Override
    @Intrinsic
    public double figura$getFov(Camera camera, float tickDelta, boolean changingFov) {
        return this.getFov(camera, tickDelta, changingFov);
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")})
    private void onRenderLevel(DeltaTracker deltaTracker, CallbackInfo ci) {
        this.hasShaders = ClientAPI.hasShaderPack();
    }

    @ModifyArg(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"))
    private PoseStack renderLevelBobHurt(PoseStack stack) {
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        if (!RenderUtils.vanillaModelAndScript(avatar) || this.hasShaders) {
            return stack;
        }
        stack.pushPose();
        stack.last().pose().identity();
        return stack;
    }

    @WrapOperation(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V")})
    private void figura$stopBobView(GameRenderer instance, PoseStack stack, float f, Operation<GameRenderer> original) {
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        if (!RenderUtils.vanillaModelAndScript(avatar) || this.hasShaders) {
            original.call(new Object[]{instance, stack, Float.valueOf(f)});
        }
    }

    @WrapOperation(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V")})
    private void figura$stopBobHurt(GameRenderer instance, PoseStack stack, float f, Operation<GameRenderer> original) {
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        if (!RenderUtils.vanillaModelAndScript(avatar) || this.hasShaders) {
            original.call(new Object[]{instance, stack, Float.valueOf(f)});
        }
    }

    @WrapOperation(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;", ordinal=1)})
    private <T> T figura$disableConfusionOnMatrix(OptionInstance<T> instance, Operation<T> original) {
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity()));
        return (T)(!RenderUtils.vanillaModelAndScript(avatar) || this.hasShaders ? original.call(new Object[]{instance}) : Double.valueOf(0.0));
    }
}

